/******************************************************************************
 * 	qam - a qt 'abfahrtsmonitor
 *	Copyright (C) 2007  gf@nichtcool.de
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *	USA.
 *****************************************************************************/

#include "viewconfigure.h"
#include "options.h"

CViewConfigure::CViewConfigure(QWidget* parent, Qt::WFlags f) :
	QWidget(parent, f),
	m_topLayout(this),

	m_groupCommonSettings("Allgemein"),
	m_gridCommonSettings(&m_groupCommonSettings),
	m_labelUpdateInterval("Aktualisierungsintervall"),
	m_spinUpdateInterval(),
	m_labelWindowTransparency("Fenstertransparenz"),
	m_spinWindowTransparency(),
	m_labelWindowAlwaysOnTop("Fenster immer zuoberst"),
	m_checkWindowAlwaysOnTop(),
	
	m_groupAbout("ber"),
	m_layoutAbout(&m_groupAbout),
	m_labelAbout(),

	m_widgetButtons(),
	m_layoutButtons(&m_widgetButtons),
	m_buttonApply("Anwenden"),
	m_buttonReset("Zurcksetzen"),
	m_widgetButtonSpacer()
{
	m_topLayout.setMargin(2);

	// set up settings group

	m_topLayout.addWidget(&m_groupCommonSettings);
	m_gridCommonSettings.addWidget(&m_labelUpdateInterval, 0, 0, Qt::AlignVCenter);
	m_gridCommonSettings.addWidget(&m_spinUpdateInterval, 0, 1, Qt::AlignVCenter);
		m_spinUpdateInterval.setRange(10, 300);
		m_spinUpdateInterval.setSingleStep(10);
		m_spinUpdateInterval.setSuffix(" sek");
	m_gridCommonSettings.addWidget(&m_labelWindowTransparency, 1, 0, Qt::AlignVCenter);
	m_gridCommonSettings.addWidget(&m_spinWindowTransparency, 1, 1, Qt::AlignVCenter);
		m_spinWindowTransparency.setRange(0, 99);
		m_spinWindowTransparency.setSingleStep(1);
		m_spinWindowTransparency.setSuffix(" %");
	m_gridCommonSettings.addWidget(&m_labelWindowAlwaysOnTop, 2, 0, Qt::AlignVCenter);
	m_gridCommonSettings.addWidget(&m_checkWindowAlwaysOnTop, 2, 1, Qt::AlignVCenter);
		m_checkWindowAlwaysOnTop.setEnabled(false);
	m_gridCommonSettings.addWidget(&m_spacerCommonSettings, 3, 0, 1, 2, Qt::AlignVCenter);
	m_gridCommonSettings.setRowStretch(3, 100); // take up as much space as possible

	// set up about

	m_topLayout.addWidget(&m_groupAbout);
	m_layoutAbout.addWidget(&m_labelAbout);
	m_layoutAbout.setMargin(3);
	m_layoutAbout.setSpacing(0);
		QString about = "copyright (C) 2007 by gf@nichtcool.de\n\n"
						"Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation verffentlicht, weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz.\n\n"
						"Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.\n\n"
						"Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA.";
		m_labelAbout.setText(about);
		m_labelAbout.setReadOnly(true);

	// set up button group

	m_topLayout.addWidget(&m_widgetButtons);
	m_widgetButtons.setLayout(&m_layoutButtons);
	m_layoutButtons.setMargin(5);
	m_layoutButtons.setSpacing(2);
	m_layoutButtons.addWidget(&m_widgetButtonSpacer);
		m_layoutButtons.setAlignment(&m_widgetButtonSpacer, Qt::AlignLeft);
	m_layoutButtons.addWidget(&m_buttonApply);
		m_layoutButtons.setAlignment(&m_buttonApply, Qt::AlignRight);
		m_buttonApply.setEnabled(false);
	m_layoutButtons.addWidget(&m_buttonReset);
		m_layoutButtons.setAlignment(&m_buttonReset, Qt::AlignRight);
		m_buttonReset.setEnabled(false);

	// load settings

	loadSettings();

	// set up events

	connect(&m_buttonApply, SIGNAL(clicked(bool)),
				this, SLOT(onButtonApplyClicked(bool)));
	connect(&m_buttonReset, SIGNAL(clicked(bool)),
				this, SLOT(onButtonResetClicked(bool)));
	connect(&m_spinUpdateInterval, SIGNAL(valueChanged(int)),
				this, SLOT(onSpinButtonvalueChanged(int)));
	connect(&m_spinWindowTransparency, SIGNAL(valueChanged(int)),
				this, SLOT(onSpinButtonvalueChanged(int)));
	connect(&m_checkWindowAlwaysOnTop, SIGNAL(stateChanged(int)),
				this, SLOT(onCheckBoxStateChanged(int)));
}

CViewConfigure::~CViewConfigure()
{

}

void CViewConfigure::closeEvent(QCloseEvent *event)
{	
	writeSettings();
	event->accept();
}

void CViewConfigure::loadSettings()
{
	COptions& settings = COptions::getInstance();
	settings.beginGroup("ConfigurePage");
		// ...
    settings.endGroup();
	settings.beginGroup("MainWindow");
		m_spinUpdateInterval.setValue(settings.value("updateInterval", 10).toInt());
		double fVal = settings.value("windowOpacity", 80).toDouble();
		int nVal = (100 - (int)(fVal * 100));
		m_spinWindowTransparency.setValue(nVal);
#if 0
		m_checkWindowAlwaysOnTop.setCheckState(settings.value("alwaysOnTop", true).toBool() ? Qt::Checked : Qt::Unchecked);
#endif
    settings.endGroup();
}

void CViewConfigure::writeSettings()
{
	COptions& settings = COptions::getInstance();
	settings.beginGroup("ConfigurePage");
		// ...
    settings.endGroup();
	settings.beginGroup("MainWindow");
		settings.setValue("updateInterval", m_spinUpdateInterval.value());
		double val = (double)(100 - m_spinWindowTransparency.value()) / 100;
		settings.setValue("windowOpacity", val);
#if 0
		settings.setValue("alwaysOnTop", m_checkWindowAlwaysOnTop.checkState() == Qt::Checked ? true : false);
#endif
    settings.endGroup();

	QStringList list("ConfigurePage");
	list += "MainWindow";
	settings.adviseOfChanges(list, (void*)this);
}

void CViewConfigure::onValuesChanged(QStringList& affected, void* causer)
{
	if((causer != (void*)this) && (affected.contains("ConfigurePage") || affected.contains("MainWindow"))) {
		loadSettings();
	}
}

void CViewConfigure::onButtonApplyClicked(bool)
{
	writeSettings();
	m_buttonApply.setEnabled(false);
	m_buttonReset.setEnabled(false);
}

void CViewConfigure::onButtonResetClicked(bool)
{
	loadSettings();
	m_buttonApply.setEnabled(false);
	m_buttonReset.setEnabled(false);
}

void CViewConfigure::onComboBoxTextChanged(const QString& text)
{
	m_buttonApply.setEnabled(true);
	m_buttonReset.setEnabled(true);
}

void CViewConfigure::onSpinButtonvalueChanged(int i)
{
	m_buttonApply.setEnabled(true);
	m_buttonReset.setEnabled(true);
}

void CViewConfigure::onCheckBoxStateChanged(int state)
{
	m_buttonApply.setEnabled(true);
	m_buttonReset.setEnabled(true);
}