/******************************************************************************
 * 	qam - a qt 'abfahrtsmonitor
 *	Copyright (C) 2007  gf@nichtcool.de
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *	USA.
 *****************************************************************************/

#ifndef _VIEWCONFIGURE_H_
#define _VIEWCONFIGURE_H_

#include <QWidget>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QGroupBox>
#include <QComboBox>
#include <QLabel>
#include <QSpinBox>
#include <QCheckBox>
#include <QPushButton>
#include <QCloseEvent>
#include <QTextEdit>

class CViewConfigure : public QWidget 
{
	Q_OBJECT

  public:
	CViewConfigure(QWidget* parent = 0, Qt::WFlags f = 0);
	~CViewConfigure();

  protected:
	void closeEvent(QCloseEvent *event);

  public slots:
	void onValuesChanged(QStringList& affected, void* causer);

  private slots:
	void onButtonApplyClicked(bool);
	void onButtonResetClicked(bool);
	void onComboBoxTextChanged(const QString& text);
	void onSpinButtonvalueChanged(int i); 
	void onCheckBoxStateChanged(int state);

  private:
	QVBoxLayout m_topLayout;
	
	QGroupBox m_groupCommonSettings;
		QGridLayout m_gridCommonSettings;
		QLabel m_labelUpdateInterval;
		QSpinBox m_spinUpdateInterval;
		QLabel m_labelWindowTransparency;
		QSpinBox m_spinWindowTransparency;
		QLabel m_labelWindowAlwaysOnTop;
		QCheckBox m_checkWindowAlwaysOnTop;
		QWidget m_spacerCommonSettings;

	QGroupBox m_groupAbout;
		QVBoxLayout m_layoutAbout;
		QTextEdit m_labelAbout;

	QWidget m_widgetButtons;
		QHBoxLayout m_layoutButtons;
		QPushButton m_buttonApply;
		QPushButton m_buttonReset;
		QWidget m_widgetButtonSpacer;

	void loadSettings();
	void writeSettings();
};

#endif // #ifndef _VIEWCONFIGURE_H_