/******************************************************************************
 * 	qam - a qt 'abfahrtsmonitor
 *	Copyright (C) 2007  gf@nichtcool.de
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *	USA.
 *****************************************************************************/

#ifndef _MONITOR_H_
#define _MONITOR_H_

#include <QObject>
#include <QString>
#include <QHttp>
#include <QTimer>

#include <QWidget>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QListWidget>
#include <QPushButton>
#include <QTabWidget>
#include <QCloseEvent>

#include "connectionentry.h"
#include "viewmonitor.h"
#include "viewsetmonitor.h"
#include "viewconfigure.h"

class CMonitor : public QWidget
{
	Q_OBJECT

  public:

	CMonitor(QWidget* parent = 0, Qt::WFlags = 0);
	~CMonitor();

  protected:
	void closeEvent(QCloseEvent *event);

  public slots:
	void onValuesChanged(QStringList& affected, void* causer);

  private slots:

	void onButtonMonitorClicked();
	void onButtonSetMonitorClicked();
	void onButtonConfigureClicked();

	void onResponseHeaderReceived(const QHttpResponseHeader &responseHeader);
	void onHttpRequestFinished(int requestId, bool error);
	void onTimer();

  private:

	QVBoxLayout m_topLayout;
	QTabWidget	m_tabWidget;

	CViewMonitor m_pageMonitor;
	CViewSetMonitor m_pageSetMonitor;
	CViewConfigure m_pageConfigure;

	int m_nUpdateInterval; // in seconds
	QTimer m_timer;

	QString m_location;
	QString m_station;
	QString m_eta;

	QHttp m_Http;
	int m_nHttpRequestId;
	bool m_bHttpRequestFailed;

	bool getNewConnections();

	void loadSettings();
	void writeSettings();
};

#endif // #ifndef _MONITOR_H_