/******************************************************************************
 * 	qam - a qt 'abfahrtsmonitor
 *	Copyright (C) 2007  gf@nichtcool.de
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *	USA.
 *****************************************************************************/

#include "viewmonitor.h"

CViewMonitor::CViewMonitor(QWidget* parent, Qt::WFlags f) :
	QWidget(parent, f),
	m_topLayout(this)
{
	m_topLayout.setSpacing(0);
	m_topLayout.setMargin(0);
	m_topLayout.addWidget(&m_tableWidget);
	m_tableWidget.setColumnCount(3);
	QStringList headerLabels("Linie"); headerLabels += "Haltestelle"; headerLabels += "Abfahrt";
	m_tableWidget.setHeaderLabels(headerLabels);
	m_tableWidget.setRootIsDecorated(false);
}

CViewMonitor::~CViewMonitor()
{
}

void CViewMonitor::Update(QList<ConnectionEntry> & connections)
{
	int i, n = connections.size();
	QString qstrItem;

	m_tableWidget.clear();

	for(i=0; i<n; i++) {
		const ConnectionEntry & c = connections.at(i);
		QTreeWidgetItem* item = new QTreeWidgetItem(&m_tableWidget);
		item->setText(0, c.ident);
		item->setText(1, c.direction);
		item->setText(2, c.eta);

		m_tableWidget.addTopLevelItem(item);
	}

	m_tableWidget.resizeColumnToContents(0);
	m_tableWidget.resizeColumnToContents(1);
	m_tableWidget.resizeColumnToContents(2);
}

void CViewMonitor::closeEvent(QCloseEvent *event)
{	
	writeSettings();
	event->accept();
}

void CViewMonitor::loadSettings()
{
	COptions& settings = COptions::getInstance();
	settings.beginGroup("MonitorPage");
		// ...
    settings.endGroup();
}

void CViewMonitor::writeSettings()
{
	COptions& settings = COptions::getInstance();
	settings.beginGroup("MonitorPage");
		// ...
    settings.endGroup();

	QStringList list("MonitorPage");
	settings.adviseOfChanges(list, (void*)this);
}

void CViewMonitor::onValuesChanged(QStringList& affected, void* causer)
{
	if((causer != (void*)this) && affected.contains("MonitorPage")) {
		loadSettings();
	}
}