/******************************************************************************
 * 	qam - a qt 'abfahrtsmonitor
 *	Copyright (C) 2007  gf@nichtcool.de
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *	USA.
 *****************************************************************************/

#ifndef _VIEWMONITOR_H_
#define _VIEWMONITOR_H_

#include <QWidget>
#include <QVBoxLayout>
#include <QTreeWidget>
#include <QList>
#include <QCloseEvent>

#include "options.h"
#include "connectionentry.h"

class CViewMonitor : public QWidget 
{
	Q_OBJECT

  public:
	CViewMonitor(QWidget* parent = 0, Qt::WFlags f = 0);
	~CViewMonitor();

	void Update(QList<ConnectionEntry> & connections);

  protected:
	void closeEvent(QCloseEvent *event);

  public slots:
	void onValuesChanged(QStringList& affected, void* causer);

  private:
	QVBoxLayout m_topLayout;
	QTreeWidget m_tableWidget;

	void loadSettings();
	void writeSettings();
};

#endif // #ifndef _VIEWMONITOR_H_