/******************************************************************************
 * 	qam - a qt 'abfahrtsmonitor
 *	Copyright (C) 2007  gf@nichtcool.de
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *	USA.
 *****************************************************************************/

#include "viewsetmonitor.h"
#include "options.h"

CViewSetMonitor::CViewSetMonitor(QWidget* parent, Qt::WFlags f) :
	QWidget(parent, f),
	m_topLayout(this),

	m_groupCommonSettings("Wichtiges"),
	m_gridCommonSettings(&m_groupCommonSettings),
	m_labelLocation("Ort"),
	m_comboLocation(),
	m_labelStation("Haltestelle"),
	m_comboStation(),
	m_labelTimeOffset("Abfahrt in"),
	m_spinTimeOffset(),

	m_widgetButtons(),
	m_layoutButtons(&m_widgetButtons),
	m_buttonApply("Anwenden"),
	m_buttonReset("Zurcksetzen"),
	m_widgetButtonSpacer()
{
	m_topLayout.addWidget(&m_groupCommonSettings);
	m_topLayout.setMargin(2);
	m_gridCommonSettings.addWidget(&m_labelLocation, 0, 0, Qt::AlignVCenter);
	m_gridCommonSettings.addWidget(&m_comboLocation, 0, 1, Qt::AlignVCenter);
		m_comboLocation.setEditable(true);
	m_gridCommonSettings.addWidget(&m_labelStation, 1, 0, Qt::AlignVCenter);
	m_gridCommonSettings.addWidget(&m_comboStation, 1, 1, Qt::AlignVCenter);
		m_comboStation.setEditable(true);
	m_gridCommonSettings.addWidget(&m_labelTimeOffset, 2, 0, Qt::AlignVCenter);
	m_gridCommonSettings.addWidget(&m_spinTimeOffset, 2, 1, Qt::AlignVCenter);
		m_spinTimeOffset.setRange(0, 60);
		m_spinTimeOffset.setSingleStep(1);
		m_spinTimeOffset.setSuffix(" min");
	m_gridCommonSettings.addWidget(&m_spacerCommonSettings, 3, 0, 1, 2, Qt::AlignVCenter);
	m_gridCommonSettings.setRowStretch(3, 100); // take up as much space as possible

	// set up button group

	m_topLayout.addWidget(&m_widgetButtons);
	m_widgetButtons.setLayout(&m_layoutButtons);
	m_layoutButtons.setMargin(5);
	m_layoutButtons.setSpacing(2);
	m_layoutButtons.addWidget(&m_widgetButtonSpacer);
		m_layoutButtons.setAlignment(&m_widgetButtonSpacer, Qt::AlignLeft);
	m_layoutButtons.addWidget(&m_buttonApply);
		m_layoutButtons.setAlignment(&m_buttonApply, Qt::AlignRight);
		m_buttonApply.setEnabled(false);
	m_layoutButtons.addWidget(&m_buttonReset);
		m_layoutButtons.setAlignment(&m_buttonReset, Qt::AlignRight);
		m_buttonReset.setEnabled(false);

	// load settings

	loadSettings();

	// set up events

	connect(&m_buttonApply, SIGNAL(clicked(bool)),
				this, SLOT(onButtonApplyClicked(bool)));
	connect(&m_buttonReset, SIGNAL(clicked(bool)),
				this, SLOT(onButtonResetClicked(bool)));
	connect(&m_spinTimeOffset, SIGNAL(valueChanged(int)),
				this, SLOT(onSpinButtonvalueChanged(int)));
	connect(&m_comboLocation, SIGNAL(editTextChanged(const QString&)),
				this, SLOT(onComboBoxTextChanged(const QString&)));
	connect(&m_comboStation, SIGNAL(editTextChanged(const QString&)),
				this, SLOT(onComboBoxTextChanged(const QString&)));
}

CViewSetMonitor::~CViewSetMonitor()
{

}

void CViewSetMonitor::closeEvent(QCloseEvent *event)
{	
	writeSettings();
	event->accept();
}

void CViewSetMonitor::loadSettings()
{
	COptions& settings = COptions::getInstance();
	settings.beginGroup("SetMonitorPage");
		// ...
    settings.endGroup();
	settings.beginGroup("MonitorPage");
		
    settings.endGroup();
	settings.beginGroup("Monitor");
		m_comboLocation.insertItem(0, settings.value("location", "Dresden").toString());
		m_comboStation.insertItem(0, settings.value("station", "Albertplatz").toString());
		m_spinTimeOffset.setValue(settings.value("eta", 3).toInt());
	settings.endGroup();
}

void CViewSetMonitor::writeSettings()
{
	COptions& settings = COptions::getInstance();
	settings.beginGroup("SetMonitorPage");
		// ...
    settings.endGroup();
	settings.beginGroup("MonitorPage");
		// ...
    settings.endGroup();
	settings.beginGroup("Monitor");
		settings.setValue("location", m_comboLocation.currentText());
		settings.setValue("station", m_comboStation.currentText());
		settings.setValue("eta", m_spinTimeOffset.value());
	settings.endGroup();

	QStringList list("SetMonitorPage");
	list += "MonitorPage";
	list += "Monitor";
	settings.adviseOfChanges(list, (void*)this);
}

void CViewSetMonitor::onValuesChanged(QStringList& affected, void* causer)
{
	if((causer != (void*)this) && (affected.contains("SetMonitorPage") || affected.contains("MonitorPage") || affected.contains("Monitor"))) {
		loadSettings();
	}
}

void CViewSetMonitor::onButtonApplyClicked(bool)
{
	writeSettings();
	m_buttonApply.setEnabled(false);
	m_buttonReset.setEnabled(false);
}

void CViewSetMonitor::onButtonResetClicked(bool)
{
	loadSettings();
	m_buttonApply.setEnabled(false);
	m_buttonReset.setEnabled(false);
}

void CViewSetMonitor::onComboBoxTextChanged(const QString& text)
{
	m_buttonApply.setEnabled(true);
	m_buttonReset.setEnabled(true);
}

void CViewSetMonitor::onSpinButtonvalueChanged(int i)
{
	m_buttonApply.setEnabled(true);
	m_buttonReset.setEnabled(true);
}

void CViewSetMonitor::onCheckBoxStateChanged(int state)
{
	m_buttonApply.setEnabled(true);
	m_buttonReset.setEnabled(true);
}